<?php
include 'config.php';
$status_file = 'email_status.txt';
$last_id = file_exists($status_file) ? file_get_contents($status_file) : 0;

// Use your actual email credentials here:
$email_account = "your-email@seemon.mohobd.com";
$email_password = "your-email-password";

// Connect to email
$host = "{mail.seemon.mohobd.com:993/imap/ssl}INBOX";
$inbox = imap_open($host, $email_account, $email_password);

if ($inbox) {
    $emails = imap_search($inbox, 'UNSEEN');
    if ($emails) {
        foreach ($emails as $email_id) {
            $header = imap_headerinfo($inbox, $email_id);
            $to = $header->toaddress;
            
            if (strpos($to, 'inbox_') !== false) {
                // Extract chat ID from email
                preg_match('/inbox_(\d+)/', $to, $matches);
                if (isset($matches[1])) {
                    $chat_id = $matches[1];
                    $subject = $header->subject;
                    
                    // Get first part of email
                    $body = imap_body($inbox, $email_id);
                    
                    // Look for codes
                    $code = '';
                    if (preg_match('/\b(\d{4,6})\b/', $body, $code_match)) {
                        $code = $code_match[1];
                    }
                    
                    // Send to Telegram
                    $message = "📧 New email\nSubject: $subject";
                    if ($code) {
                        $message .= "\nCode: `$code`";
                    }
                    
                    file_get_contents("https://api.telegram.org/bot$BOT_TOKEN/sendMessage?chat_id=$chat_id&text=" . urlencode($message) . "&parse_mode=Markdown");
                    
                    // Mark as read
                    imap_setflag_full($inbox, $email_id, "\\Seen");
                }
            }
            $last_id = $email_id;
        }
        file_put_contents($status_file, $last_id);
    }
    imap_close($inbox);
}
echo "Done";
?>